#ifndef __ONE_WIRE_H
#define __ONE_WIRE_H

/* 
	One Wire Dallas Drivers using a single IO Pin & UART...
	 
	by Mauro Grassi, August 2010.

	
*/

#include "demo_board_hardware.h"
#include "hardwarestate.h"

#define ONE_WIRE_TIMEOUT				1000

#define BAUD_9600_VALUE					((unsigned int)(((GetSystemClock()/(9600))/4)-1))
#define ONE_WIRE_UART_BAUD_H_LOW_SPEED	((unsigned char)(BAUD_9600_VALUE>>8))
#define ONE_WIRE_UART_BAUD_L_LOW_SPEED	((unsigned char)(BAUD_9600_VALUE & 0xFF))

#define ONE_WIRE_RESPONSE_BUFFER_SIZE	16

#define DEBUG_ONE_WIRE					0

extern unsigned char 		oneWireResponseBuffer[ONE_WIRE_RESPONSE_BUFFER_SIZE];

unsigned char CRCOneWire(unsigned char* chr, unsigned int cnt);
void oneWireWaitus(unsigned int x);
void oneWireWaitms(unsigned int ms);
unsigned char putResetPulse(HARDWARE_DESCRIPTOR* hd);
void putWriteSlot(HARDWARE_DESCRIPTOR* hd, unsigned char x);
unsigned char getReadBit(HARDWARE_DESCRIPTOR* hd);
char sendOneWireCommand(HARDWARE_DESCRIPTOR* hd, unsigned char cmd, unsigned int numBitsPacket, unsigned char* dataBuffer, unsigned char mode, unsigned int msPullUp);
void showOneWireResponse(unsigned int numBits, unsigned char* pointer);
void getOneWireState(HARDWARE_DESCRIPTOR* hd);
void closeOneWireState(HARDWARE_DESCRIPTOR* hd);
void initOneWireState(HARDWARE_DESCRIPTOR* hd);
void copyOneWireRomCode(HARDWARE_DESCRIPTOR* hd, unsigned char offset, unsigned char direction);

#endif
